/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IBorderStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.ui.BorderStyle;
import snownee.jade.overlay.IconUI;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.Color;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    public static DecimalFormat dfCommas = new DecimalFormat("##.##");
    private static final Pattern STRIP_COLOR;

    @Override
    public void drawItem(class_4587 matrixStack, float x, float y, class_1799 stack, float scale, @Nullable String text) {
        if (OverlayRenderer.alpha < 0.5f) {
            return;
        }
        RenderSystem.enableDepthTest();
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34425(matrixStack.method_23760().method_23761());
        float o = 8.0f * scale;
        modelViewStack.method_22904((double)(x + o), (double)(y + o), 0.0);
        modelViewStack.method_22905(scale *= Math.min(1.0f, OverlayRenderer.alpha + 0.2f), scale, scale);
        modelViewStack.method_22904(-8.0, -8.0, 0.0);
        CLIENT.method_1480().method_4010(stack, 0, 0);
        DisplayHelper.renderGuiItemDecorations(DisplayHelper.CLIENT.field_1772, stack, text);
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableDepthTest();
    }

    private static void renderGuiItemDecorations(class_327 font, class_1799 stack, @Nullable String p_115179_) {
        class_746 localplayer;
        float f;
        if (stack.method_7960()) {
            return;
        }
        class_4587 posestack = new class_4587();
        if (stack.method_7947() != 1 || p_115179_ != null) {
            String s = p_115179_ == null ? INSTANCE.humanReadableNumber(stack.method_7947(), "", false) : p_115179_;
            posestack.method_22903();
            posestack.method_22904(0.0, 0.0, (double)(DisplayHelper.CLIENT.method_1480().field_4730 + 200.0f));
            posestack.method_22905(0.75f, 0.75f, 0.75f);
            class_4597.class_4598 multibuffersource$buffersource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            font.method_27521(s, (float)(22 - font.method_1727(s)), 13.0f, 0xFFFFFF, true, posestack.method_23760().method_23761(), (class_4597)multibuffersource$buffersource, false, 0, 0xF000F0);
            multibuffersource$buffersource.method_22993();
            posestack.method_22909();
        }
        if (stack.method_31578()) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.disableBlend();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            int i = stack.method_31579();
            int j = stack.method_31580();
            DisplayHelper.draw(posestack, bufferbuilder, 2.0f, 13.0f, 13, 2, 0, 0, 0, 255);
            DisplayHelper.draw(posestack, bufferbuilder, 2.0f, 13.0f, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            RenderSystem.enableBlend();
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
        float f2 = f = (localplayer = class_310.method_1551().field_1724) == null ? 0.0f : localplayer.method_7357().method_7905(stack.method_7909(), class_310.method_1551().method_1488());
        if (f > 0.0f) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_289 tesselator1 = class_289.method_1348();
            class_287 bufferbuilder1 = tesselator1.method_1349();
            DisplayHelper.draw(posestack, bufferbuilder1, 0.0f, 0 + class_3532.method_15375((float)(16.0f * (1.0f - f))), 16, class_3532.method_15386((float)(16.0f * f)), 255, 255, 255, 127);
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
    }

    private static void draw(class_4587 ms, class_287 renderer, float x, float y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.setShader(class_757::method_34540);
        class_1159 matrix = ms.method_23760().method_23761();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22918(matrix, x, y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(matrix, x, y + (float)height, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(matrix, x + (float)width, y + (float)height, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(matrix, x + (float)width, y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)renderer.method_1326());
    }

    @Override
    public void drawGradientRect(class_4587 matrixStack, float left, float top, float width, float height, int startColor, int endColor) {
        this.drawGradientRect(matrixStack, left, top, width, height, startColor, endColor, false);
    }

    public void drawGradientRect(class_4587 matrixStack, float left, float top, float width, float height, int startColor, int endColor, boolean horizontal) {
        float zLevel = 0.0f;
        class_1159 matrix = matrixStack.method_23760().method_23761();
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        if (horizontal) {
            buffer.method_22918(matrix, left + width, top, zLevel).method_22915(f5, f6, f7, f4).method_1344();
            buffer.method_22918(matrix, left, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top + height, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left + width, top + height, zLevel).method_22915(f5, f6, f7, f4).method_1344();
        } else {
            buffer.method_22918(matrix, left + width, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top + height, zLevel).method_22915(f5, f6, f7, f4).method_1344();
            buffer.method_22918(matrix, left + width, top + height, zLevel).method_22915(f5, f6, f7, f4).method_1344();
        }
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    @Override
    public void drawBorder(class_4587 matrixStack, float minX, float minY, float maxX, float maxY, IBorderStyle border0) {
        BorderStyle border = (BorderStyle)border0;
        this.drawBorder(matrixStack, minX, minY, maxX, maxY, border.width, border.color, true);
    }

    @Override
    public void drawBorder(class_4587 matrixStack, float minX, float minY, float maxX, float maxY, float width, int color, boolean corner) {
        DisplayHelper.fill(matrixStack, minX + width, minY, maxX - width, minY + width, color);
        DisplayHelper.fill(matrixStack, minX + width, maxY - width, maxX - width, maxY, color);
        if (corner) {
            DisplayHelper.fill(matrixStack, minX, minY, minX + width, maxY, color);
            DisplayHelper.fill(matrixStack, maxX - width, minY, maxX, maxY, color);
        } else {
            DisplayHelper.fill(matrixStack, minX, minY + width, minX + width, maxY - width, color);
            DisplayHelper.fill(matrixStack, maxX - width, minY + width, maxX, maxY - width, color);
        }
    }

    public static void drawTexturedModalRect(class_4587 matrixStack, float x, float y, int textureX, int textureY, int width, int height, int tw, int th) {
        class_1159 matrix = matrixStack.method_23760().method_23761();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(matrix, x, y + (float)height, zLevel).method_22913((float)textureX * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22918(matrix, x + (float)width, y + (float)height, zLevel).method_22913((float)(textureX + tw) * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22918(matrix, x + (float)width, y, zLevel).method_22913((float)(textureX + tw) * f, (float)textureY * f1).method_1344();
        buffer.method_22918(matrix, x, y, zLevel).method_22913((float)textureX * f, (float)textureY * f1).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static void renderIcon(class_4587 matrixStack, float x, float y, int sx, int sy, IconUI icon) {
        if (icon == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)OverlayRenderer.alpha);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (icon.bu != -1) {
            DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }

    public void drawFluid(class_4587 matrixStack, float xPosition, float yPosition, @Nullable class_3610 fluidState, float width, float height, long capacityMb) {
        if (OverlayRenderer.alpha < 0.5f) {
            return;
        }
        if (fluidState == null || fluidState.method_15769()) {
            return;
        }
        class_3611 fluid = fluidState.method_15772();
        if (fluid == null) {
            return;
        }
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        class_1058 fluidStillSprite = handler.getFluidSprites(null, null, fluidState)[0];
        int fluidColor = handler.getFluidColor(null, null, fluidState);
        long amount = 81000L;
        float scaledAmount = (float)amount * height / (float)capacityMb;
        if (amount > 0L && scaledAmount < 1.0f) {
            scaledAmount = 1.0f;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        this.drawTiledSprite(matrixStack, xPosition, yPosition, width, height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(class_4587 matrixStack, float xPosition, float yPosition, float tiledWidth, float tiledHeight, int color, float scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_1159 matrix = matrixStack.method_23760().method_23761();
        DisplayHelper.setGLColorFromInt(color);
        int xTileCount = (int)(tiledWidth / 16.0f);
        float xRemainder = tiledWidth - (float)(xTileCount * 16);
        int yTileCount = (int)(scaledAmount / 16.0f);
        float yRemainder = scaledAmount - (float)(yTileCount * 16);
        float yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = xPosition + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DisplayHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(class_1159 matrix, float xCoord, float yCoord, class_1058 textureSprite, float maskTop, float maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void fill(class_4587 matrixStack, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(matrixStack.method_23760().method_23761(), minX, minY, maxX, maxY, color);
    }

    private static void fill(class_1159 matrix, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(matrix, minX, maxY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, maxX, maxY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, maxX, minY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, minX, minY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        boolean n;
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        if (number < 1000.0) {
            sb.append(dfCommas.format(number));
            if (milli && number != 0.0) {
                sb.append('m');
            }
        } else {
            int exp = (int)(Math.log10(number) / 3.0);
            if (exp > 7) {
                exp = 7;
            }
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(dfCommas.format(number / Math.pow(1000.0, exp)));
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(class_4587 poseStack, String text, float x, float y, int color) {
        this.drawText(poseStack, (class_2561)class_2561.method_43470((String)text), x, y, color);
    }

    @Override
    public void drawText(class_4587 poseStack, class_2561 text, float x, float y, int color) {
        boolean shadow = Jade.CONFIG.get().getOverlay().getTheme().textShadow;
        if (OverlayRenderer.alpha != 1.0f) {
            color = IWailaConfig.IConfigOverlay.applyAlpha(color, OverlayRenderer.alpha);
        }
        if (shadow) {
            DisplayHelper.CLIENT.field_1772.method_30881(poseStack, text, x, y, color);
        } else {
            DisplayHelper.CLIENT.field_1772.method_30883(poseStack, text, x, y, color);
        }
    }

    public void drawGradientProgress(class_4587 matrixStack, float left, float top, float width, float height, float progress, int progressColor) {
        Color color = Color.rgb(progressColor);
        Color highlight = Color.hsl(color.getHue(), color.getSaturation(), Math.min(color.getLightness() + 0.2, 1.0), color.getOpacity());
        if (progress < 0.1f) {
            this.drawGradientRect(matrixStack, left, top, width * progress, height, progressColor, highlight.toInt(), true);
        } else {
            float hlWidth = width * 0.1f;
            float normalWidth = width * progress - hlWidth;
            DisplayHelper.fill(matrixStack, left, top, left + normalWidth, top + height, progressColor);
            this.drawGradientRect(matrixStack, left + normalWidth, top, hlWidth, height, progressColor, highlight.toInt(), true);
        }
    }

    @Override
    public class_5250 stripColor(class_2561 component) {
        class_5250 mutableComponent = class_2561.method_43473();
        component.method_27658((style, string) -> {
            if (!string.isEmpty()) {
                class_5250 literal = class_2561.method_43470((String)STRIP_COLOR.matcher(string).replaceAll(""));
                literal.method_27696(style.method_27703((class_5251)null));
                mutableComponent.method_10852((class_2561)literal);
            }
            return Optional.empty();
        }, class_2583.field_24360);
        return mutableComponent;
    }

    static {
        dfCommas.setRoundingMode(RoundingMode.DOWN);
        STRIP_COLOR = Pattern.compile("(?i)\u00a7[0-9A-F]");
    }
}

